using System;
using System.Xml;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Gumps;
using Server.Spells;
using Server.Spells.First;
using Server.Spells.Second;
using Server.Spells.Third;
using Server.Spells.Fourth;
using Server.Spells.Fifth;
using Server.Spells.Sixth;
using Server.Spells.Seventh;
using Server.Spells.Eighth;
using Server.Spells.Chivalry;
using System.Collections;
using System.Collections.Generic;


namespace Server.Regions
{
	public class FireRegion : DungeonRegion
	{
		public FireRegion( XmlElement xml, Map map, Region parent ) : base( xml, map, parent )
		{
		}
		
		public static int RandomFireHue { get { return Utility.RandomList( 1092, 1066, 1059, 1068, 1078, 1161, 1198, 1259, 1360, 1932, 
         2019, 2020, 2021, 2162, 2163, 2449, 2454, 2487, 2640, 2622 ); } }

		public override bool OnBeginSpellCast( Mobile m, ISpell s )
		{
			if ( m.AccessLevel > AccessLevel.Player || !m.Player || ((Spell)s).Scroll != null )
				return base.OnBeginSpellCast( m, s );
			
			if ( s is GateTravelSpell || s is RecallSpell || s is MarkSpell/* || s is PaladinSpell*/ || s is InvisibilitySpell ||
			    s is AirElementalSpell || s is EarthElementalSpell || s is FireElementalSpell || s is SummonDaemonSpell || s is WaterElementalSpell ||
			    s is Server.Spells.Necromancy.NecromancerSpell || s is Server.Spells.Spellweaving.ArcanistSpell || s is Server.Spells.Ninjitsu.NinjaSpell ||
			    s is Server.Spells.SamuraiMove || s is Server.Spells.Bushido.SamuraiSpell || s is EnergyVortexSpell /*|| s is WallOfStoneSpell*/ || s is IncognitoSpell ||
			    s is TeleportSpell || s is Server.Spells.NinjaMove || s is MagicTrapSpell || s is PolymorphSpell || s is MagicLockSpell )
			{
				m.SendLocalizedMessage( 501802 ); // Thy spell doth not appear to work...
				return false;
			}
			
			return base.OnBeginSpellCast( m, s );
		}

		public override bool AllowHousing( Mobile from, Point3D p )
		{
			return false;
		}

		public override bool CanUseStuckMenu( Mobile m )
		{
			return true;
		}
		
		public override bool OnDoubleClick(Mobile m, object o)
		{
			if ( m.AccessLevel > AccessLevel.Player )
				return base.OnDoubleClick(m, o);
			
			if ( /*o is BaseMagicalFood || */o is SuperPotion || o is TotalManaRefreshPotion || o is BankCrystal )
			{
				m.SendMessage( "Tento predmet zde nemuzes pouzit" );
				return false;
			}
			
			if ( o is BasePotion )
			{
				if ( !m.BeginAction( typeof( BasePotion ) ) )
				{
					m.SendMessage( "Jeste nemuzes lektvar pouzit" );
					return false;
				}
				else
					Timer.DelayCall( TimeSpan.FromMinutes( 1.0 ), new TimerStateCallback( ReleasePotionLock ), m );
			}

			return base.OnDoubleClick(m, o);
		}
		
		private static void ReleasePotionLock( object state )
		{
			((Mobile)state).EndAction( typeof( BasePotion ) );
		}
		
		public override bool OnDeath( Mobile m )
		{
			if ( m is BaseCreature && Utility.RandomDouble() < 0.01 )
         {
            BaseCreature bc = (BaseCreature) m;
            
            if ( !bc.Controlled && bc.FightMode != FightMode.Aggressor && bc.IsTeragon && bc.Fame > 10000 )
			      bc.PackItem( new BottledFire( 1 ) );
         }
			
			return base.OnDeath( m );
		}
	}
}
